from flask import Flask, render_template
import folium
from folium.plugins import Draw
from folium.plugins import MarkerCluster

app = Flask(__name__)

@app.route('/')
def index():
    start_coords = (33.583991, -7.616326)
    ma_carte = folium.Map(location=start_coords, zoom_start=14)
    draw = Draw(export=True)
    draw.add_to(ma_carte)
    ma_carte.save('templates/html/index_map.html')
    return render_template('/html/index.html')

@app.route('/carte_simple')
def carte_simple():
    start_coords = (33.583991, -7.616326)
    ma_carte = folium.Map(location=start_coords, zoom_start=14)
    marker_cluster = MarkerCluster().add_to(ma_carte)

    folium.Marker(location=[40.67, -73.94], popup='Add popup text here.',
        icon=folium.Icon(color='green', icon='ok-sign'), ).add_to(marker_cluster)

    folium.Marker(location=[44.67, -73.94], popup='Add popup text here.',
        icon=folium.Icon(color='red', icon='remove-sign'), ).add_to(marker_cluster)

    folium.Marker(location=[44.67, -71.94], popup='Add popup text here.',
        icon=None, ).add_to(marker_cluster)

    ma_carte.save('templates/html/index_map.html')
    return render_template('/html/carte_simple.html')

if __name__ == '__main__':
    app.run(debug=True)
