# Imports
import folium
import random
from scipy.spatial import ConvexHull

# Function to create a list of some random points
def randome_points(amount, LON_min, LON_max, LAT_min, LAT_max):

    points = []
    for _ in range(amount):
        points.append((random.uniform(LON_min, LON_max),random.uniform(LAT_min, LAT_max)))

    return(points)

# Function to draw points in the map
def draw_points(map_object, list_of_points, layer_name, line_color, fill_color, text):

    fg = folium.FeatureGroup(name=layer_name)

    for point in list_of_points:
        fg.add_child(folium.CircleMarker(point, radius=1, color=line_color, fill_color=fill_color,
                                         popup=(folium.Popup(text))))

    map_object.add_child(fg)

# Function that takes a map and a list of points (LON,LAT tupels) and
# returns a map with the convex hull polygon from the points as a new layer

def create_convexhull_polygon(map_object, list_of_points, layer_name, line_color, fill_color, weight, text):

    # Since it is pointless to draw a convex hull polygon around less than 3 points check len of input
    if len(list_of_points) < 3:
        return

    # Create the convex hull using scipy.spatial
    form = [list_of_points[i] for i in ConvexHull(list_of_points).vertices]

    # Create feature group, add the polygon and add the feature group to the map
    fg = folium.FeatureGroup(name=layer_name)
    fg.add_child(folium.vector_layers.Polygon(locations=form, color=line_color, fill_color=fill_color,
                                              weight=weight, popup=(folium.Popup(text))))
    map_object.add_child(fg)

    return(map_object)

# Initialize map
my_convexhull_map = folium.Map(location=[48.5, 9.5], zoom_start=8)

# Create a convex hull polygon that contains some points
list_of_points = randome_points(amount=10, LON_min=48, LON_max=49, LAT_min=9, LAT_max=10)

create_convexhull_polygon(my_convexhull_map, list_of_points, layer_name='Le Secteur',
                        line_color='red', fill_color='red', weight=5, text='Le Secteur')

draw_points(my_convexhull_map, list_of_points, layer_name='Liste des Clients',
           line_color='darkred', fill_color='darkred', text='Liste des Clients')

# Add layer control and show map
folium.LayerControl(collapsed=False).add_to(my_convexhull_map)
my_convexhull_map

#Ici c'est la dernière ligne NE RIEN METTRE APRES
my_convexhull_map.save('index.html')