
# Register your models here.
from django.contrib import admin
from .models import *

# Register your models here.
class EventAdminSite(admin.ModelAdmin):
    site_header = "UMSRA Events Admin"
    site_title = "UMSRA Events Admin Portal"
    index_title = "Welcome to UMSRA Researcher Events Portal"

class TaxesAdmin(admin.ModelAdmin):
    list_display = ('CodeTaxe', 'Taux')
    search_fields = ('CodeTaxe', 'Taux')
    list_filter = ('CodeTaxe', 'Date_creation')
    list_per_page = 100
    date_hierarchy = 'Date_creation'

class ExercicesAdmin(admin.ModelAdmin):
    list_display = ('Annee', 'DateDebut', 'DateFin', 'Cloturer')
    search_fields = ('Annee', 'DateDebut')
    list_filter = ('Annee', 'DateDebut')
    list_per_page = 100
    date_hierarchy = 'DateDebut'

    fieldsets = (
        ('Section 1', {
            'fields': ('Annee', )
        }),
        ('Section 2', {
            'fields': ('DateDebut', 'DateFin')
        }),
        ('Section 3', {
            'fields': ('Cloturer', )
        }),
    )

class PeriodesAdmin(admin.ModelAdmin):
    list_display = ('Annee', 'DateDebut', 'DateFin', 'Cloturer')
    search_fields = ('Annee', 'DateDebut')
    list_filter = ('Annee', 'DateDebut')
    list_per_page = 100
    date_hierarchy = 'DateDebut'
    readonly_fields = ["Cloturer"]

admin.site.register(Liste_des_Taxes, TaxesAdmin)
admin.site.register(Liste_des_Exercices, ExercicesAdmin)
admin.site.register(Liste_des_Periodes, PeriodesAdmin)