from django.urls import path
from commerciale import views
from django.contrib import admin

app_name = 'main'

admin.site.site_header = "Gestion Commercial"
admin.site.site_title = "Portail Gestion Commercial"
admin.site.index_title = "Bienvenue dans Gestion Commercial"

urlpatterns = [
    path('admin/', admin.site.urls),
    path('', views.page_accueil, name="page_accueil"),
    path("enregistrement/", views.enregistrement, name="enregistrement"),
    path("deconnexion/", views.deconnexion, name="deconnexion"),
    path("connexion/", views.connexion, name="connexion"),
    path("liste_clients/", views.liste_clients, name="liste_clients"),
]
