from django.shortcuts import render, redirect
from commerciale.models import Client
from django.contrib.auth.forms import AuthenticationForm
from django.contrib.auth import logout, authenticate, login
from django.contrib import messages
from .forms import NouveauUtilisateur

# Create your views here.
def page_accueil(request):
    return render(request = request,
                  template_name='login/index.html',
                  context = {"Client":Client.objects.all})

def enregistrement(request):
    if request.method == "POST":
        form = NouveauUtilisateur(request.POST)
        if form.is_valid():
            user = form.save()
            username = form.cleaned_data.get('username')
            messages.success(request, f"New account created: {username}")
            login(request, user)
            return redirect("main:page_accueil")

        else:
            for msg in form.error_messages:
                messages.error(request, f"{msg}: {form.error_messages[msg]}")

            return render(request = request,
                          template_name = "login/enregistrement.html",
                          context={"form":form})

    form = NouveauUtilisateur
    return render(request = request,
                  template_name = "login/enregistrement.html",
                  context={"form":form})

def deconnexion(request):
    logout(request)
    messages.info(request, "Logged out successfully!")
    return redirect("main:page_accueil")

def connexion(request):
    if request.method == 'POST':
        form = AuthenticationForm(request=request, data=request.POST)
        if form.is_valid():
            username = form.cleaned_data.get('username')
            password = form.cleaned_data.get('password')
            user = authenticate(username=username, password=password)
            if user is not None:
                login(request, user)
                messages.info(request, f"You are now logged in as {username}")
                return redirect('/')
            else:
                messages.error(request, "Invalid username or password.")
        else:
            messages.error(request, "Invalid username or password.")
    form = AuthenticationForm()
    return render(request = request,
                    template_name = "login/connexion.html",
                    context={"form":form})

def liste_clients(request):
    return render(request = request,
                  template_name='login/liste_clients.html',
                  context = {"Client":Client.objects.all})