// Procedures globales du projet
// Résumé : Permet de tracer un trajet à partir d'un fichier KML
// Syntaxe :
// GoogleMapsDessineKML (sURL)
//
// Paramètres :
//	sURL  : URL du fichier KML (http://..../<fichier.kml>)
// Valeur de retour :

function AfficheKML(sURL)
{
	var ctaLayer = new google.maps.KmlLayer(sURL);
	ctaLayer.setMap(gObjCarte);
	KMLArray.push(ctaLayer);
	// on renvoie l'objet KMLLayer
	return ctaLayer;
}

// Résumé : Permet de dessiner l'itinéraire entre une adresse de départ et une adresse d'arrivée.
// Syntaxe :
// AfficheItineraireAvecEtape ()
//
// Paramètres :
//	addressStart : // chaine. Correspond à l'adresse de départ
//	adressEnd : // chaine. Correspond à l'adresse d'arrivée
// Valeur de retour :
// 	Aucun : 
//
function AfficheItineraireAvecEtape(addressStart,adressEnd,listeEtapes,aliasAffDetails)
{
	var waypts = [];
	for (i=0;i<listeEtapes.length;i++){
		waypts.push({
			location:listeEtapes[i],
			stopover:true});
	}

	var directions = new google.maps.DirectionsRenderer();
	var directionsService = new google.maps.DirectionsService();
	var request = {
		origin:addressStart, 
		destination:adressEnd,
		waypoints: waypts,
		optimizeWaypoints: true,
		travelMode: google.maps.DirectionsTravelMode.DRIVING
		};
	directionsService.route(request, function(response, status) {
		if (status == google.maps.DirectionsStatus.OK) {
			directions.setDirections(response);
			var route = response.routes[0];
//			var summaryPanel = document.getElementById('directions_panel');
			var summaryPanel = document.getElementById(aliasAffDetails);
			summaryPanel.innerHTML = '';
			// For each route, display summary information.
			for (var i = 0; i < route.legs.length; i++) {
				var routeSegment = i + 1;
				summaryPanel.innerHTML += '<b>Route Segment: ' + routeSegment + '</b><br>';
				summaryPanel.innerHTML += route.legs[i].start_address + ' to ';
				summaryPanel.innerHTML += route.legs[i].end_address + '<br>';
				summaryPanel.innerHTML += route.legs[i].distance.text + '<br><br>';
				}
			}
		});
	directionsArray.push(directions);
	directions.setMap(gObjCarte);
	
	// on renvoie l'objet itinéraire
	return directionsArray;
}
// Récupération de l'objet carte.
function Recupere_API_Carte(obj)
{
	// affectation à la variable globale navigateur.
	gObjCarte = obj;
}

// Affiche un marqueur
function Afficher_Marqueur(nLatitude, nLongitude, sIcone, bDragAndDropAutorise, sTexteInfoClic, nPrecision)
{
	
	if (!gObjCarte)
	return ;
	
	var objCoordonnees;
	var objMarqueur;
	
	// Si la longitude et la latitude sont renseignées, on crée une coordonnée avec ces données
	if (nLatitude && nLongitude)
	{
		objCoordonnees = new google.maps.LatLng(nLatitude, nLongitude)
	}else{
		// si la latitude et la longitude ne sont pas renseignées, on prend le centre de la carte
		objCoordonnees = gObjCarte.getCenter();
	}
	
	if (bDragAndDropAutorise == null)
	bDragAndDropAutorise = true;
	
	// Gestion de l'icône du marqueur
	if(sIcone=="")
	{
		sIcone = null;
	}
	else{
		var tempIcon = {
			url:sIcone
		}
	}
	
	
	// Gestion du cercle de précision
	if (nPrecision != null)
	{
		var options = {
			map:gObjCarte,
			center:objCoordonnees,
			radius:eval(nPrecision),
			fillColor: "#0088FF",
			fillOpacity: 0.2,
			strokeColor: "#0088FF",
			strokeOpacity: 0.5,
			strokeWeight: 1,
			clickable: false
		}
		var cercle = new google.maps.Circle(options);
		circlesArray.push(cercle);
	} 
	
	// Création du marqueur
	// Si on ne spécifie pas cette option, elle ne pourra pas être activée après coup
	var options = {
		draggable:bDragAndDropAutorise,
		position:objCoordonnees,
		map:gObjCarte,
		icon:tempIcon
	};
	// Ajout du marqueur
	objMarqueur = new google.maps.Marker(options); 
	markersArray.push(objMarqueur);
	
	// Ajout de l'info bulle si besoin
	if (sTexteInfoClic) {
		google.maps.event.addListener(objMarqueur, 'click', function() {
			if (!this.getMap()._infoWindow) {
				this.getMap()._infoWindow = new google.maps.InfoWindow();
			}
			this.getMap()._infoWindow.close();
			this.getMap()._infoWindow.setContent(sTexteInfoClic);
			this.getMap()._infoWindow.open(this.getMap(), this);
		});
	}
	
	// On renvoie l'objet marqueur
	return objMarqueur;	
}

var markersArray = [];
var circlesArray = [];
var linesArray = [];
var markerClusterer = null;
var rectangleArray = [];
var polygoneArray = [];
var KMLArray = [];
var directionsArray = [];

// Résumé : Permet de créer des regroupements de marqueurs
// Syntaxe :
// GoogleMapsCreerMarkerClusterer (pts)
//
// Paramètres :
//	pts  : tableau de chaines de caractères. Format : ["46.1206559;4.305847","43.518518;1.559973",etc...]
// Valeur de retour :
// 	Aucune
//
function Marqeur_Clustrer(pts)
{
	Clustererbounds = new google.maps.LatLngBounds();
	gnListemark = [];
	var point = new Array(pts.length);
	for (i=0;i<pts.length;i++){
		var ch = pts[i];
		var tot = ch.split(";");	
		var latLng = new google.maps.LatLng(tot[0],tot[1]);
		var marker = new google.maps.Marker({
			position: latLng,
			draggable: false
		});
		gnListemark.push(marker);
		// mémorise la position : sert à centrer la carte ultérieurement sur l'ensemble du tracé
		Clustererbounds.extend(latLng);
		
	}
	
	var mcOptions = {gridSize: 50, maxZoom: 15};
	markerClusterer = new MarkerClusterer(gObjCarte, gnListemark,mcOptions);
	
	// création de la vue englobant l'ensemble des marqueurs
	gObjCarte.fitBounds(Clustererbounds);
	
	// on renvoie l'objet clusterer
	return markerClusterer;
}


// Résumé : Permet de tracer un trajet sur une carte et de faire parcourir ce tracé par une flèche par exemple.
// Syntaxe :
// GoogleMapsSymbolsAnime (pts)
//
// Paramètres :
//	pts  : Tableau de chaines de caractères. Format ["lat;lng","lat;lng",....]
// Valeur de retour :
// 	Aucune
function Trajet_Anime(pts)
{
	
	PtsBounds = new google.maps.LatLngBounds(); 
	lineCoordinates = [];
	var point = new Array(pts.length);
	for (i=0;i<pts.length;i++){
		var ch = pts[i];
		var tot = ch.split(";");	
		var latLng = new google.maps.LatLng(tot[0],tot[1]);
		
		lineCoordinates.push(latLng);
		// mémorise la position : sert à centrer la carte ultérieurement sur l'ensemble du tracé
		PtsBounds.extend(latLng);
	}
	
	var lineSymbol = {
		path: google.maps.SymbolPath.FORWARD_CLOSED_ARROW,
		scale: 4,
		strokeColor: '#393'
	};
	
	line = new google.maps.Polyline({
		path: lineCoordinates,
		icons: [{
			icon: lineSymbol,
			offset: '200%'
		}],
		map: gObjCarte
	});
	var count = 0;
	offsetId = window.setInterval(function() {
		count = (count + 1) % 200;
		
		var icons = line.get('icons');
		icons[0].offset = (count / 2) + '%';
		line.set('icons', icons);
	}, 40);
	linesArray.push(line);
	// création de la vue englobant le tracé
	//gObjCarte.fitBounds(PtsBounds);
	
	// on renvoie l'objet polyline
	return line;
}

//
